/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.rs6k;

import com.ibm.hsc.cim.exceptions.HSCCIMException;
import com.ibm.hsc.cim.provider.rs6k.HscProviderConstants;
import com.ibm.hsc.cim.provider.rs6k.HscProviderUtils;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.HscProviderSocket;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.common.util.VersionComparator;
import com.ibm.websm.diagnostics.IDebug;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;
import org.snia.wbem.client.ProviderCIMOMHandle;
import org.snia.wbemcfg.GlobalConfig;

public class LEDUtils {
    static final short COMMIT_CHANGES = 1;
    static final short READ_CLOSE = 128;
    static final short CANCEL_CHANGES = 255;
    static final int PAD = 0;
    static final int BYTE_OFFSET = 0;
    static final int BYTEBUFFER = 200;
    static final int SYSTEM_ATTN_LED = 64;
    static final int IDENTIFY_LED = 128;

    protected static CIMValue isLEDTypeSupported(CIMObjectPath cIMObjectPath, Vector vector, Vector vector2, String string, HscProviderSocket hscProviderSocket, ProviderCIMOMHandle providerCIMOMHandle) throws CIMException {
        Trace.trace("apcshscD", "in LEDUtils.isLEDTypeSupported method");
        System.out.println("In isLEDTypeSupported!");
        int n = 0;
        try {
            int n2 = 0;
            n2 = GlobalConfig.callMethodsWithValues ? ((UnsignedInt8)((CIMValue)vector.elementAt(0)).getValue()).intValue() : ((UnsignedInt8)((CIMProperty)vector.elementAt(0)).getValue().getValue()).intValue();
            System.out.println("LED type: " + n2);
            int n3 = VersionComparator.CSPVersionValue(string);
            System.out.println("Version: " + n3);
            if ((float)n3 >= 3000.0f) {
                n = 1;
            }
            UnsignedInt16 unsignedInt16 = new UnsignedInt16(n);
            vector2.setSize(1);
            if (GlobalConfig.callMethodsWithValues) {
                vector2.setElementAt(new CIMValue((Object)unsignedInt16), 0);
            } else {
                vector2.setElementAt(new CIMProperty("Supported", new CIMValue((Object)unsignedInt16)), 0);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
            throw new HSCCIMException(throwable);
        }
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    protected static CIMValue getLEDTypeList(CIMObjectPath cIMObjectPath, Vector vector, Vector vector2, String string, HscProviderSocket hscProviderSocket, ProviderCIMOMHandle providerCIMOMHandle) throws CIMException {
        Trace.trace("apcshscD", "in LEDUtils.getLEDTypeList method");
        System.out.println("In getLEDTypeList!");
        try {
            Object object;
            Object object2;
            int n = VersionComparator.CSPVersionValue(string);
            System.out.println("Version: " + n);
            if ((float)n < 3000.0f) {
                throw new HSCCIMException("3001");
            }
            int n2 = 0;
            n2 = GlobalConfig.callMethodsWithValues ? ((UnsignedInt8)((CIMValue)vector.elementAt(0)).getValue()).intValue() : ((UnsignedInt8)((CIMProperty)vector.elementAt(0)).getValue().getValue()).intValue();
            System.out.println("LED type: " + n2);
            String[] stringArray = new String[]{Integer.toHexString(n2)};
            Hashtable hashtable = HscProviderUtils.doCSPCommand(HscProviderConstants.OPEN_TABLE_FOR_READ, stringArray, hscProviderSocket, string);
            int n3 = (int)((Long)hashtable.get("FILE_SIZE")).longValue();
            System.out.println("File size: " + n3);
            hashtable = HscProviderUtils.doCSPCommand("GET_MTU_SIZE_FIELDS", null, hscProviderSocket, string);
            int n4 = (int)((Long)hashtable.get("MTU_SIZE")).longValue();
            int n5 = n4 - 200;
            System.out.println("max. read size: " + n5);
            int n6 = 0;
            int n7 = 1;
            if (n3 > n5) {
                double d = (double)n3 / (double)n5;
                System.out.println("tmp: " + d);
                double d2 = Math.ceil(d);
                n7 = (int)d2;
                System.out.println("num: " + n7);
            }
            String string2 = "";
            int n8 = 1;
            int n9 = n3 % n5;
            System.out.println("leftOver = " + n9);
            if (n3 > n5) {
                n8 = n9 != 0 ? n3 / n5 + 1 : n3 / n5;
            }
            int n10 = 0;
            while (n10 < n8) {
                System.out.println("offset: " + n6);
                stringArray = new String[]{Integer.toHexString(n2), Integer.toString(n6), n10 != n8 - 1 || n9 == 0 ? Integer.toString(n5) : Integer.toString(n9)};
                hashtable = HscProviderUtils.doCSPCommand(HscProviderConstants.READ_TABLE_ENTRIES, stringArray, hscProviderSocket, string);
                object2 = (byte[])hashtable.get("BYTES_READ");
                object = new String((byte[])object2);
                System.out.println("infoString: " + (String)object);
                string2 = string2.concat((String)object);
                System.out.println("ledDataString: " + string2);
                n6 += n5;
                ++n10;
            }
            stringArray = new String[]{Integer.toHexString(n2), Integer.toHexString(128)};
            hashtable = HscProviderUtils.doCSPCommand(HscProviderConstants.CLOSE_TABLE, stringArray, hscProviderSocket, string);
            object2 = string2.substring(0, 4);
            object = ((String)object2).getBytes();
            int n11 = object[0] << 24 & 0xFF000000 | object[1] << 16 & 0xFF0000 | object[2] << 8 & 0xFF00 | object[3] & 0xFF;
            System.out.println("numPairs: " + n11);
            int n12 = n11 * 2;
            String[] stringArray2 = new String[n12];
            System.out.println("ledDataString.length() = " + string2.length());
            stringArray2 = LEDUtils._parseLedData(string2.substring(4).getBytes(), n11);
            vector2.setSize(1);
            if (GlobalConfig.callMethodsWithValues) {
                vector2.setElementAt(new CIMValue((Object)stringArray2, new CIMDataType(29)), 0);
            } else {
                vector2.setElementAt(new CIMProperty("LEDList", new CIMValue((Object)stringArray2, new CIMDataType(29))), 0);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
            throw new HSCCIMException("3002");
        }
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    protected static CIMValue setLED(CIMObjectPath cIMObjectPath, Vector vector, String string, HscProviderSocket hscProviderSocket, ProviderCIMOMHandle providerCIMOMHandle) throws CIMException {
        Trace.trace("apcshscD", "in LEDUtils.setLEDState method");
        System.out.println("In setLEDState!");
        boolean bl = false;
        int n = 1;
        if (IDebug.enabled) {
            System.out.println("MKS: SETTING LED STATE");
        }
        while (!bl) {
            try {
                int n2 = VersionComparator.CSPVersionValue(string);
                System.out.println("Version: " + n2);
                if ((float)n2 < 3000.0f) {
                    throw new HSCCIMException("3001");
                }
                int n3 = 0;
                int n4 = 0;
                int n5 = 0;
                if (GlobalConfig.callMethodsWithValues) {
                    n3 = ((UnsignedInt8)((CIMValue)vector.elementAt(0)).getValue()).intValue();
                    n4 = ((UnsignedInt32)((CIMValue)vector.elementAt(1)).getValue()).intValue();
                    n5 = ((UnsignedInt16)((CIMValue)vector.elementAt(2)).getValue()).intValue();
                } else {
                    n3 = ((UnsignedInt8)((CIMProperty)vector.elementAt(0)).getValue().getValue()).intValue();
                    n4 = ((UnsignedInt32)((CIMProperty)vector.elementAt(1)).getValue().getValue()).intValue();
                    n5 = ((UnsignedInt16)((CIMProperty)vector.elementAt(2)).getValue().getValue()).intValue();
                }
                System.out.println("LED type: " + n3);
                System.out.println("LED index: " + n4);
                System.out.println("Setting: " + n5);
                if (n3 == 1) {
                    n3 = 64;
                }
                if (n3 == 2) {
                    n3 = 128;
                }
                String[] stringArray = new String[]{Integer.toString(n3), Integer.toHexString(0), Integer.toString(n4), Integer.toHexString(n5)};
                Hashtable hashtable = HscProviderUtils.doCSPCommand("SET_CEC_LED_STATE", stringArray, hscProviderSocket, string);
                bl = true;
            }
            catch (HSCCIMException hSCCIMException) {
                if (hSCCIMException.getID().equals("0210")) {
                    if (IDebug.enabled) {
                        System.out.println("MKS: setLED Got busy exception, retrying " + n);
                    }
                    if (n > 7) {
                        if (IDebug.enabled) {
                            System.out.println("MKS: setLED Got busy exception, bail out");
                        }
                        hSCCIMException.printStackTrace();
                        HSCLogUtils.serverLog((Throwable)((Object)hSCCIMException), HSCLogUtils._CECClassLogInfo);
                        throw hSCCIMException;
                    }
                    if (IDebug.enabled) {
                        System.out.println("MKS: setLED Got busy exception (0x0d), so try again ");
                    }
                    try {
                        Thread.sleep(5000L);
                        ++n;
                    }
                    catch (Throwable throwable) {
                        throw hSCCIMException;
                    }
                    hSCCIMException.printStackTrace();
                    HSCLogUtils.serverLog((Throwable)((Object)hSCCIMException), HSCLogUtils._CECClassLogInfo);
                    continue;
                }
                hSCCIMException.printStackTrace();
                HSCLogUtils.serverLog((Throwable)((Object)hSCCIMException), HSCLogUtils._CECClassLogInfo);
                throw hSCCIMException;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
                throw new HSCCIMException("3002");
            }
        }
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    protected static CIMValue getLEDState(CIMObjectPath cIMObjectPath, Vector vector, Vector vector2, String string, HscProviderSocket hscProviderSocket, ProviderCIMOMHandle providerCIMOMHandle) throws CIMException {
        Trace.trace("apcshscD", "in LEDUtils.getLEDState method");
        System.out.println("In getLEDState!");
        int n = 0;
        boolean bl = false;
        int n2 = 1;
        if (IDebug.enabled) {
            System.out.println("MKS: GETTING LED STATE");
        }
        while (!bl) {
            try {
                int n3 = VersionComparator.CSPVersionValue(string);
                System.out.println("Version: " + n3);
                if ((float)n3 < 3000.0f) {
                    throw new HSCCIMException("3001");
                }
                int n4 = 0;
                int n5 = 0;
                if (GlobalConfig.callMethodsWithValues) {
                    n4 = ((UnsignedInt8)((CIMValue)vector.elementAt(0)).getValue()).intValue();
                    n5 = ((UnsignedInt32)((CIMValue)vector.elementAt(1)).getValue()).intValue();
                } else {
                    n4 = ((UnsignedInt8)((CIMProperty)vector.elementAt(0)).getValue().getValue()).intValue();
                    n5 = ((UnsignedInt32)((CIMProperty)vector.elementAt(1)).getValue().getValue()).intValue();
                }
                System.out.println("LED type: " + n4);
                System.out.println("LED index: " + n5);
                if (n4 == 1) {
                    n4 = 64;
                }
                if (n4 == 2) {
                    n4 = 128;
                }
                String[] stringArray = new String[]{Integer.toString(n4), Integer.toHexString(0), Integer.toString(n5)};
                if (IDebug.enabled) {
                    System.err.println("Args are " + stringArray);
                }
                Hashtable hashtable = HscProviderUtils.doCSPCommand("GET_CEC_LED_STATE", stringArray, hscProviderSocket, string);
                n = (Integer)hashtable.get("LED_STATE");
                UnsignedInt16 unsignedInt16 = new UnsignedInt16(n);
                vector2.setSize(1);
                if (GlobalConfig.callMethodsWithValues) {
                    vector2.setElementAt(new CIMValue((Object)unsignedInt16), 0);
                } else {
                    vector2.setElementAt(new CIMProperty("state", new CIMValue((Object)unsignedInt16)), 0);
                }
                bl = true;
            }
            catch (HSCCIMException hSCCIMException) {
                if (hSCCIMException.getID().equals("0210")) {
                    if (IDebug.enabled) {
                        System.out.println("MKS: getLED Got busy exception, retrying " + n2);
                    }
                    if (n2 > 7) {
                        if (IDebug.enabled) {
                            System.out.println("MKS: getLED Got busy exception, bail out");
                        }
                        hSCCIMException.printStackTrace();
                        HSCLogUtils.serverLog((Throwable)((Object)hSCCIMException), HSCLogUtils._CECClassLogInfo);
                        throw hSCCIMException;
                    }
                    if (IDebug.enabled) {
                        System.out.println("MKS: getLED Got busy exception (0x0d), so try again ");
                    }
                    try {
                        Thread.sleep(5000L);
                        ++n2;
                    }
                    catch (Throwable throwable) {
                        throw hSCCIMException;
                    }
                    hSCCIMException.printStackTrace();
                    HSCLogUtils.serverLog((Throwable)((Object)hSCCIMException), HSCLogUtils._CECClassLogInfo);
                    continue;
                }
                hSCCIMException.printStackTrace();
                HSCLogUtils.serverLog((Throwable)((Object)hSCCIMException), HSCLogUtils._CECClassLogInfo);
                throw hSCCIMException;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
                throw new HSCCIMException("3002");
            }
        }
        return new CIMValue((Object)new UnsignedInt8(0));
    }

    private static String[] _parseLedData(byte[] byArray, int n) {
        String[] stringArray = null;
        if (byArray != null && byArray.length != 0) {
            int n2 = 0;
            while (n2 < byArray.length) {
                System.out.println("data[" + n2 + "] = " + byArray[n2]);
                ++n2;
            }
            boolean bl = false;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            if (n != 0) {
                stringArray = new String[n * 2];
                while (n3 < n) {
                    long l = (long)(byArray[n4] << 24) & 0xFF000000L | (long)(byArray[n4 + 1] << 16) & 0xFF0000L | (long)(byArray[n4 + 2] << 8) & 0xFF00L | (long)byArray[n4 + 3] & 0xFFL;
                    System.out.println("indexVal = " + l);
                    long l2 = (long)(byArray[n4 + 4] << 24) & 0xFF000000L | (long)(byArray[n4 + 5] << 16) & 0xFF0000L | (long)(byArray[n4 + 6] << 8) & 0xFF00L | (long)byArray[n4 + 7] & 0xFFL;
                    n5 = n4 += 8;
                    while (byArray[n4] != 0) {
                        ++n4;
                    }
                    String string = new String(byArray, n5, n4 - n5);
                    System.out.println("loc = " + string);
                    n4 = n5 + (int)l2;
                    stringArray[n3 * 2] = string;
                    stringArray[n3 * 2 + 1] = Long.toString(l);
                    ++n3;
                }
            }
        }
        return stringArray;
    }
}

